/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedMishapEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerBasedCastEnv
extends CastingEnvironment {
    public static final double DEFAULT_AMBIT_RADIUS = 32.0;
    private double ambitRadius;
    public static final double DEFAULT_SENTINEL_RADIUS = 16.0;
    private double sentinelRadius;
    protected final class_3222 caster;
    protected final class_1268 castingHand;

    protected PlayerBasedCastEnv(class_3222 caster, class_1268 castingHand) {
        super(caster.method_51469());
        this.caster = caster;
        this.castingHand = castingHand;
        this.ambitRadius = caster.method_26825(HexAttributes.AMBIT_RADIUS);
        this.sentinelRadius = caster.method_26825(HexAttributes.SENTINEL_RADIUS);
    }

    @Override
    public class_1309 getCastingEntity() {
        return this.caster;
    }

    @Override
    public class_3222 getCaster() {
        return this.caster;
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        for (OperatorSideEffect sideEffect : result.getSideEffects()) {
            if (!(sideEffect instanceof OperatorSideEffect.DoMishap)) continue;
            OperatorSideEffect.DoMishap doMishap = (OperatorSideEffect.DoMishap)sideEffect;
            this.sendMishapMsgToPlayer(doMishap);
        }
        if (this.caster != null) {
            double sentinelAttribute;
            double ambitAttribute = this.caster.method_26825(HexAttributes.AMBIT_RADIUS);
            if (this.ambitRadius != ambitAttribute) {
                this.ambitRadius = ambitAttribute;
            }
            if (this.sentinelRadius != (sentinelAttribute = this.caster.method_26825(HexAttributes.SENTINEL_RADIUS))) {
                this.sentinelRadius = sentinelAttribute;
            }
        }
    }

    @Override
    protected List<class_1799> getUsableStacks(CastingEnvironment.StackDiscoveryMode mode) {
        return this.getUsableStacksForPlayer(mode, this.castingHand, this.caster);
    }

    @Override
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        return this.getPrimaryStacksForPlayer(this.castingHand, this.caster);
    }

    public double getAmbitRadius() {
        return this.ambitRadius;
    }

    public double getSentinelRadius() {
        return this.sentinelRadius;
    }

    @Override
    public boolean replaceItem(Predicate<class_1799> stackOk, class_1799 replaceWith, @Nullable class_1268 hand) {
        return this.replaceItemForPlayer(stackOk, replaceWith, hand, this.caster);
    }

    @Override
    public boolean isVecInRangeEnvironment(class_243 vec) {
        Sentinel sentinel = HexAPI.instance().getSentinel(this.caster);
        if (sentinel != null && sentinel.extendsRange() && this.caster.method_37908().method_27983() == sentinel.dimension() && vec.method_1025(sentinel.position()) <= this.sentinelRadius * this.sentinelRadius + 1.0E-11) {
            return true;
        }
        return vec.method_1025(this.caster.method_19538()) <= this.ambitRadius * this.ambitRadius + 1.0E-11;
    }

    @Override
    public boolean hasEditPermissionsAtEnvironment(class_2338 pos) {
        return this.caster.field_13974.method_14257() != class_1934.field_9216 && this.world.method_8505((class_1657)this.caster, pos);
    }

    protected long extractMediaFromInventory(long costLeft, boolean allowOvercast, boolean simulate) {
        ADMediaHolder source;
        long found;
        List<ADMediaHolder> sources = MediaHelper.scanPlayerForMediaStuff(this.caster);
        long startCost = costLeft;
        Iterator<ADMediaHolder> iterator = sources.iterator();
        while (iterator.hasNext() && (costLeft -= (found = MediaHelper.extractMedia(source = iterator.next(), costLeft, false, simulate))) > 0L) {
        }
        if (costLeft > 0L && allowOvercast) {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthToRemove = Math.max((double)costLeft / mediaToHealth, 0.5);
            if (simulate) {
                long simulatedRemovedMedia = class_3532.method_15384((double)(Math.min((double)this.caster.method_6032(), healthToRemove) * mediaToHealth));
                if (this.caster.method_5679(this.caster.method_48923().method_48795(HexDamageTypes.OVERCAST))) {
                    simulatedRemovedMedia = 0L;
                }
                costLeft -= simulatedRemovedMedia;
            } else {
                double mediaAbleToCastFromHP = (double)this.caster.method_6032() * mediaToHealth;
                Mishap.trulyHurt((class_1309)this.caster, this.caster.method_48923().method_48795(HexDamageTypes.OVERCAST), (float)healthToRemove);
                int actuallyTaken = class_3532.method_15384((double)(mediaAbleToCastFromHP - (double)this.caster.method_6032() * mediaToHealth));
                HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(this.caster, actuallyTaken);
                this.caster.method_7339(HexStatistics.MEDIA_OVERCAST, actuallyTaken);
                costLeft -= (long)actuallyTaken;
            }
        }
        if (!simulate) {
            this.caster.method_7339(HexStatistics.MEDIA_USED, (int)(startCost - costLeft));
            HexAdvancementTriggers.SPEND_MEDIA_TRIGGER.trigger(this.caster, startCost - costLeft, costLeft < 0L ? -costLeft : 0L);
        }
        return costLeft;
    }

    protected boolean canOvercast() {
        class_161 adv = this.world.method_8503().method_3851().method_12896(HexAPI.modLoc("y_u_no_cast_angy"));
        class_2985 advs = this.caster.method_14236();
        return advs.method_12882(adv).method_740();
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        return IXplatAbstractions.INSTANCE.setPigment((class_1657)this.caster, pigment);
    }

    @Override
    public void produceParticles(ParticleSpray particles, FrozenPigment pigment) {
        particles.sprayParticles(this.world, pigment);
    }

    @Override
    public class_243 mishapSprayPos() {
        return this.caster.method_19538();
    }

    @Override
    public MishapEnvironment getMishapEnvironment() {
        return new PlayerBasedMishapEnv(this.caster);
    }

    protected void sendMishapMsgToPlayer(OperatorSideEffect.DoMishap mishap) {
        class_2561 msg = mishap.getMishap().errorMessageWithName(this, mishap.getErrorCtx());
        if (msg != null) {
            this.caster.method_43496(msg);
        }
    }

    @Override
    protected boolean isCreativeMode() {
        return this.caster.method_31549().field_7477;
    }

    @Override
    public void printMessage(class_2561 message) {
        this.caster.method_43496(message);
    }
}

